// Handy DXl Functions

/*
This file includes a number of useful DXL functions.
*/


// ========================================================================================
//Include Files
// ========================================================================================


pragma runLim,0

// ========================================================================================
//Number strings
// ========================================================================================
string hnl = "\n"
string hsp = " "
string htb = "\t"
string hemptyStr = ""
string hdot = "."
string hcomma = ","

const string hattr01 = "Object Text"
const string hattr02 = "Object Heading"
const string hattr03 = "TableType"

const string hattrVal01 = "TableNone"
const string hattrVal02 = "TableBase"
const string hattrVal03 = "TableRow"
const string hattrVal04 = "TableCell"

const string hviewName01 = "Standard View"


// ========================================================================================
//Global Attributes
// ========================================================================================


// ========================================================================================
//Global Arrays
// ========================================================================================



// ========================================================================================
//Global Indexes
// ========================================================================================



// ========================================================================================
//Global Skip List
// ========================================================================================



// ========================================================================================
//External File Attributes
// ========================================================================================



// ========================================================================================
//Dialog Box Attributes
// ========================================================================================



//=========================================================================================
//Dialog Labels
//=========================================================================================
//The following are dialogue and column labels 


//=========================================================================================
//Triggers
//=========================================================================================

//****************************************************************************************************************
//Checks the existance of attributes in a module
//Parameters: attrName - the name of the attribute. attrType - the attribute's type
//Post Condition: returns true if it can find an attribute with the same name and type as attrName and attrType
//else returns false
bool attrExists(Module mod, string attrName)
{
noError()

string subErrorName = "Handy - attrExists - "
string subError

	AttrDef ad = find(mod, attrName)						//Find named attribute

	if(!null(ad))									//if it exists
	{
		return true								//return true
	}
	
	return false									//else return false

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//Start Progress bar
void startProg(DB x, int maxM, string startMsg, string progMsg) 
{ 
noError()

string subErrorName = "Handy - startProg - "
string subError


    	progressStart(x, startMsg , startMsg, maxM ) 					//start progress bar
	progressMessage progMsg 

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Close progress bar
void finProg(DB x) 
{ 
noError()

string subErrorName = "Handy - finProg - "
string subError

string label16 = "Exit loop?"

      if (progressCancelled) 
	{
            if (confirm(label16)) 
		{
                progressStop
                halt
		}
	}

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//
bool hasBullet(string s)
{
noError()

string subErrorName = "Handy - hasBullet - "
string subError

RichTextParagraph rp
bool hasBullet = null

	for rp in s do 
	{
		if(rp.isBullet == true)
		{
			hasBullet = rp.isBullet 
		}
	}
	return hasBullet

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//Close all open modules and delete skip lists
void cleanUp (int modMax)
{
noError()

string subErrorName = "Handy - cleanUp - "
string subError

Module openMod

bool failClose = true

string modName = ""

int modCount = 0

	startProg(dbExplorer , modMax, "Closing Modules", "")


	for openMod in database do							//Close all open modules
	{
		modName = name(openMod)
		progressStep(modCount)

		modCount++

		progressMessage modName

		failClose = close(openMod)

		if(failClose == false)
		{
			ack "Error - " name(openMod) "\n"
			failClose = true
		}

		finProg(dbExplorer)
	}
	progressStop


	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//The script returns the currenttime in seconds
int timeNow()
{
noError()

string subErrorName = "Handy - timeNow - "
string subError

	Date dN = today()								//Get todays date and current time
	int secN = intOf(dN)								//Convert to seconds

	return secN				

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
// Get start time of script
int getStartTime (bool csvFlag)
{
noError()

string subErrorName = "Handy - getStartTime - "
string subError

int startT = 0
string timeStamp = ""
string label19 = "Report executed at:\r"
Date currTime

	startT = timeNow()
	if (csvFlag == true) 
	{
		currTime = dateOf (intOf (today ()))					//get start time
		timeStamp = label19  currTime "\n"
	}

	 return startT 

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
// Get finish time of script
void getFinishTime (int startT)
{
noError()

string subErrorName = "Handy - getFinishTime - "
string subError

int finT = 0
string outStr = "Finished in - "							//Text for finished dialog
string label18 = " Seconds"

	finT = timeNow()								//get finish time
	finT = finT - startT

	outStr = outStr finT label18 ""
	ack (outStr "")		


	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//Build the file name
void fileNameBuilder ()
{
noError()

string subErrorName = "Handy - fileNameBuilder - "
string subError

Locale loc = userLocale 
string dateNow =stringOf(dateAndTime(today),loc)
string dattemp = goodFileName(dateNow)
string datetemp2 = ""

string currFilePath = currentDirectory()
string thisFileName = "DO_MDOORS_S00001_"						//File name for saved data
string thisFileName2 = "_Nnnnnnnnnn"							//File name for saved data
string thisFileName3 = "_V01"
string fileExt = ""
string fn = ""


	if (matches ("([^_]+)_([^_]+)_([^_]+)_([^_]+)_([^_]+)_([^_]+)",dattemp))
	{
		datetemp2 = "20" dattemp[match 3] dattemp[match 2] dattemp[match 1] dattemp[match 4] dattemp[match 5] dattemp[match 6] 
	}
 
	thisFileName = thisFileName datetemp2 thisFileName2 thisFileName3 
	thisFileName = goodFileName(thisFileName)
	fn = currFilePath "\\" thisFileName fileExt

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//
real getReal(int y) //this function gets real percentage info from the stats array
{
noError()

string subErrorName = "Handy - getReal - "
string subError

	real realInfo = 0.0
	//realInfo = (real get(statsInfo,posPercent,y))
	return realInfo

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//
void putPerString(string sPInfo,int y) 	//this function puts percentage string info into the stats array
{
noError()

string subErrorName = "Handy - putPerString - "
string subError

	//put(statsInfo,sPInfo,posPerString ,y)

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//
void percentConcat (int y, int sw) 							//this function perorms the rounding of the percentage value to 2 decimal places
{
noError()

string subErrorName = "Handy - percentConcat - "
string subError

real pR = 0.0
int iRound = 0
string pS = ""
string round = ""
string whole = ""
real rWhole = 0.0

int Norm = 0				//Switch for storing percentages
int Executed = 1			//Switch for storing Executed Test percentages
int TExecuted = 2			//Switch for storing Total Executed Test percentages



	if (sw == Norm) 
	{
		pR = getReal(y)
	}
	if (sw == Executed) 
	{
		pR = getReal(y)
	}

	if (sw == TExecuted) 
	{
		pR = getReal(y)
	}

	
	pS = pR ""

	if (pR != 0.0) 
	{
		round = pS[5:5]
		whole = pS[0:5]
		iRound = intOf(round)
		rWhole = realOf(whole)

		if (iRound >=5) 
		{
			rWhole = rWhole + 00.01
			if (rWhole > 100.0) 
			{
				rWhole = 100.0
			}
		}
		pS = rWhole""
		pS = pS[0:4]
  
		if (matches ("100.0",pS)) 
		{
			pS = "100.00"
		}
	}
	else 
	{
		pS = "0.00"
	}
	pS = pS "%"

	if (sw == Norm) 
	{
		putPerString(pS,y)
	}
	if (sw == Executed) 
	{
		putPerString(pS,y)
	}
	if (sw == TExecuted) 
	{
		putPerString(pS,y)
	}

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//=================
int getInt(int y) 			//this function gets integer count info from the stats array
//=================
{
noError()

string subErrorName = "Handy - getInt - "
string subError

int intInfo = 0
	//intInfo = (int get(statsInfo,posCounts,y))
	return intInfo

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//=================
void putReal(real rInfo,int y) 		//this function puts real percentage info into the stats array
//=================
{
noError()

string subErrorName = "Handy - putReal - "
string subError

	//put(statsInfo,rInfo,posPerExecute,y)

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//
void percentCalc (int y, int den, int switchs) 						//This function calculates percentage values for the Stats Array
{
noError()

string subErrorName = "Handy - percentCalc - "
string subError

real percentOut = 0.0
int num = 0


int Norm = 0				//Switch for storing percentages
int Executed = 1			//Switch for storing Executed Test percentages
int TExecuted = 2			//Switch for storing Total Executed Test percentages

	if (switchs == TExecuted) 
	{
		num = getInt(y)
	}
	else
	{
		num = getInt(y)
	}

	if (den != 0) 
	{
		percentOut = (realOf(num) / realOf(den)) *100.0
	}
	else 
	{
		percentOut = 0.0
	}

	if (switchs == Norm) 
	{
		putReal(percentOut,y)
		percentConcat(y, switchs)
	}
	if (switchs == Executed) 
	{
		putReal(percentOut,y)
		percentConcat(y, switchs)
	}

	if (switchs == TExecuted) 
	{
		putReal(percentOut,y)
		percentConcat(y, switchs)
	}

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//
void getPercent () 									//This function gets the percentage values for all the counts
{
noError()

string subErrorName = "Handy - getPercent - "
string subError

int indx = 0

int TTes = 0		//Position in array for storing info about testable objects
int ONoI = 8		//Position in array for storing info about objects with outlinks and no ininks
int DeTS = 30		//Position in array for storing info about N/A Test Cases
int PaTS = 26		//Position in array for storing info about Passed Test Cases
int IPTS = 28		//Position in array for storing info about Not Completed Test Cases
int ExTS = 24		//Position in array for storing info about Executed Test Cases
int FaTS = 27		//Position in array for storing info about Failed Test Case

int Norm = 0				//Switch for storing percentages
int Executed = 1			//Switch for storing Executed Test percentages
int TExecuted = 2			//Switch for storing Total Executed Test percentages

int denom = getInt(TTes)
	
	for indx in TTes:ONoI by 1 do 
	{
		percentCalc(indx, denom, Norm)
	}
	indx = 0

	for indx in PaTS:DeTS by 1 do 
	{
		percentCalc(indx, denom, Norm)
	}
	indx = 0

	percentCalc(PaTS, denom, TExecuted)
	percentCalc(IPTS, denom, TExecuted)	

	denom = getInt(ExTS)

	percentCalc(ExTS, denom, Executed)
	percentCalc(PaTS, denom, Executed)
	percentCalc(FaTS, denom, Executed)

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//
int datCalc(int iStr, int iFin)
{
noError()

string subErrorName = "Handy - datCalc - "
string subError

int resDays
int roundDays
int oddDays

	iStr = iStr/86400
	iFin = iFin/86400

	resDays = iFin - iStr 

	if (resDays == 0)
	{
		return 0 
	}
	
	if (resDays <=5)
	{
		return resDays 
	}
	
	if ((resDays ==6) or (resDays ==7))
	{
		return 5 
	}

	roundDays = (5*resDays)/7
	oddDays = (7 * roundDays)/5
	
	resDays = (resDays - oddDays) + roundDays 
	return resDays 

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Creates a new column and sets colour based on an attribute
int colCreate (int cCount, string attName, int widtVal, string colHead, string colColor)
{
noError()

string subErrorName = "Handy - colCreate - "
string subError

	insert(column (cCount) )
	attribute (column (cCount),attName ) 
	width(column (cCount),widtVal) 
	title (column (cCount), colHead )
	//Comment out the following line if using DOORS v9.3 or earlier
	backgroundColor (column (cCount), colColor )
	//Comment out the following line if using DOORS v9.4 or above
	//color (column (cCount), colColor )
	
	cCount++

	return cCount

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Removes new lines and full stops
int StripNewLine(Buffer b)
{
noError()

string subErrorName = "Handy - StripNewLine - "
string subError

Buffer bTempStrip = create() // create the temp buffer outside of the function for performance
setempty bTempStrip									// empty the temp buffer
int j = 0
int l = length(b)
int nlcount = 0
int fscount = 0
int count = 0
string pad = " x "

	if (l == 0) 
	{
		return 0								// nothing to do
	}
  
	for(j=0;j<l;j++) 
	{ 
		if(b[j] != '\n') 
		{
			bTempStrip += b[j] 
		}
		else
		{
			bTempStrip += pad
			nlcount++
		}
	}

	for(j=0;j<l;j++) 
	{ 
		if(b[j] != '.') 
		{
			bTempStrip += b[j] 
		}
		else
		{
			bTempStrip += pad
			fscount++
		}
	}

	setempty b
	combine (b, bTempStrip, 0)							// empty the old buffer, and replace its contents

	if (fscount == 1)
	{
		fscount = 0
	}
	count = fscount + nlcount++
	return count

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Text Checking Function
string  textCheck (string tP, string cont, string result)
{
noError()

string subErrorName = "Handy - textCheck - "
string subError

Regexp testPhase
string pad = " x "
string space = " "
string aTab = "\t"
string newLine = "\n"
string text13 = " statement found"

	cont = pad cont pad
	string body = tP[1:]
	string upL = upper( string tP[0:0])
	string lowL = lower( string tP[0:0])
	//testPhase =  regexp2 "(.*)(" space "["upL lowL"]"body space")(.*)"
	testPhase =  regexp "(.*)(" space "["upL lowL"]"body space")(.*)"


		if (testPhase cont)
		{
			result = result  aTab  tP  text13 newLine
		}
		return result

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//
bool canModObj(Object testObj)
{
noError()

string subErrorName = "Handy - canModObj - "
string subError

bool result = false

	if(!isDeleted(testObj))
	{
		if(canModify(testObj))
		{
			result = true 
		}
	}
	return result

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
bool canModMod()
{
//Boolean
bool canModify = false
bool canModifyDXL = false
bool cont = false

//Integers

//Strings
string thisClassStr


//Arrays

//Skip List

//Modules
Module thisMod = current

//Objects

//Folder and Projects

//Items

//Other
AttrDef adRec
User thisUser
UserClass thisClass


//Error Control
noError()
string subErrorName = "Handy - canModMod - "
string subError

// Fuction Code ===========================================================================

	thisUser = find()
	thisClass = thisUser.class
	thisClassStr = stringOf(thisClass)
	canModifyDXL  = thisUser.mayEditDXL

	if ((thisClassStr == "Standard") || (canModifyDXL == false))
	{
		ack "You do not have permission to run this function"
		halt
	}
	else
	{
	}
	

	canModify = canWrite(thisMod)

	if (canModify == true)
	{
		//createAttr(thisMod)
		cont = true
	}
	else
	{
		ack "Open Module in Edit Mode"
		halt
	}

	save(thisMod)
	return cont


// ========================================================================================

//Error Control
	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}




//****************************************************************************************************************
//Check if Object attribute contains OLE
bool oleCheck(Object testObj)
{
noError()

string subErrorName = "Handy - oleCheck - "
string subError

int OLECount = 0
string attr2 = "Object Text"
bool result = false

	OLECount = oleCount(testObj.attr2 )
	if (OLECount >0)
	{
		result = true 
	}
	return result

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//DXL Attribute code for updates count attribute
int countHist (Object testObj, string attr1, string attr2)
{
noError()

string subErrorName = "Handy - countHist - "
string subError

History his = null
int count =0

	for his in testObj do 
	{
		if (his.type == modifyObject) 
		{
			if ((his.attrName "" == attr1"")||(his.attrName "" == attr2"" ))
			{
				count++
			}
		}
	}
	return count

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Removes decimal places 
string decimalPtLen(real srce)
{
noError()

string subErrorName = "Handy - decimalPtLen - "
string subError

string strS = ""
string strMa = ""
string strMi = ""
string newVal = ""
int noDP = 2

strS = srce ""

	if (matches("([^.]+).(.*)",strS))
	{
		strMa = strS[match 1]
		strMi = strS[match 2] 
		strMi = strMi [0:noDP]
		newVal = strMa "." strMi
	}
	return newVal 

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//Pad function. Adds 0's to DOORS absolute Number to make it 4 difgits in length
string padOut(string theIDStr)
{
noError()

string subErrorName = "Handy - padOut - "
string subError

string NS = ""
string thePad = NS 
string padChar = "0"
int strLen = 0
int iter = 0
int reqLen = 4

	strLen = length(theIDStr)
	strLen = reqLen - strLen 

	while (strLen >0) 
	{
		thePad = thePad padChar
		strLen--
	}
	
	theIDStr = thePad theIDStr NS 

	return theIDStr 

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//For the current object get all linked objects and their attibutes
void getOutLinks(Object srcObj)
{
noError()

string subErrorName = "Handy - getOutLinks - "
string subError

Link oLink 

ModName_ mn
Module modL
string linkedDT
string lAtts = ""
int linkOCount = 0
int strLen = 0
Object trgObj 

		for oLink in srcObj->"*" do						//for all out links to curent object (to open mdules)
		{
			mn = target oLink 
			modL = read(fullName mn, false)
		}


	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//****************************************************************************************************************
//For the current object get all linked objects and their attibutes
void getInLinks(Object targetObj, string pAtts)
{
noError()

string subErrorName = "Handy - getInLinks - "
string subError

LinkRef lRef
ModName_ mn
Link l
Object srcObj
Module modC 
Module currMod = current
int linkCount = 0

	for lRef in targetObj<-"*" do							//Open all modules which have in links to current object
	{	
		mn = source lRef
		modL = read(fullName mn, false)
	}


	for l in targetObj<-"*" do							//for all in links to curent object (to open mdules)
	{
		linkCount ++
		srcObj = source l

		modC = module(srcObj)
	}

current = currMod

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//****************************************************************************************************************
//Remove Leading and trailing white space characters
string trimWhitespace(string s) 
{
noError()

string subErrorName = "Handy - trimWhitespace - "
string subError

int first = 0
int last = ( length s ) - 1

   while ( last > 0 && isspace( s[ last ] ) ) 
	last--
   
   while ( isspace( s[ first ] ) && first < last ) 
	first++
   
   if ( first == last && isspace s[first] ) 
	return ""
   
   return s[ first:last ]

	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

/*******************************************************************************
 * mysystemAttr_
 *
 */

bool mysystemAttr_(AttrDef ad) {
    //if (ad.name == (NLS_("Object Heading")) || ad.name == (NLS_("Object Text")) || ad.name == (NLS_("Object Short Text")))

    if (ad.name == ("Object Heading") || ad.name == ("Object Text"))
	return false
    else
	return ad.system

} /* systemAttr_ */

/*******************************************************************************
 * myinsertAttribute_
 *
 */

void myinsertAttribute_(string attr, Skip &skip_list, int &skip_no) 
{


    put(skip_list, skip_no++, attr)

} // insertAttribute_


/*******************************************************************************
 * myinitAttributeList
 *
 */

void myinitAttributeList_(Module m, Skip &skip_list, int &skip_no, bool rw, string type_string) 
{
    AttrDef ad

    Regexp  type_reg_exp = regexp type_string

    if (!null skip_list)
        delete skip_list

    skip_list = create
    skip_no = 0


    for ad in m do 
    {
        if (((canWrite(m, ad.name) && rw) || (canRead(m, ad.name) && !rw)) && ad.object && !ad.hidden && !mysystemAttr_ ad && type_reg_exp (ad.type).name) 
	{
            myinsertAttribute_(ad.name, skip_list, skip_no)
        }
    }

} // initAttributeList_

/*******************************************************************************
 * initAttributeList
 *
 */

void myinitAttributeList_(Module m, Skip &skip_list, int &skip_no, bool rw) {

   // myinitAttributeList_(m, skip_list, skip_no, rw, (NLS_(".*")))
   myinitAttributeList_(m, skip_list, skip_no, rw, (".*"))


} /* initAttributeList_ */


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
string getRid(string thisText)
{
//Boolean
bool found = false

//Integers
int off = 0
int len = 0

//Strings
string this = ","
string forward = ""
string back = ""
//Arrays

//Skip List

//Modules

//Objects

//Folder and Projects

//Items

//Attributes and Definitions

//Filters

//Other

//Error Control
noError()
string subErrorName = "Function Name - "
string subError

// Fuction Code ===========================================================================

	found = findPlainText(thisText, this, off, len, true)

	if (found)
	{

		back = thisText[0:off-1] "\n"
		forward = getRid(thisText[off+1:])
		
		back = back forward
		return back
	}
	else
	{
		return thisText
	}


// ========================================================================================

//Error Control
	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void getRid2(string thisText, Skip &returnList, int &index)
{
//Boolean
bool found = false

//Integers
int off = 0
int len = 0
int thisInd = 0

//Strings
string this = ","
string itemTemp = ""
string remTemp = ""

//Arrays

//Skip List

//Modules

//Objects

//Folder and Projects

//Items

//Attributes and Definitions

//Filters

//Other

//Error Control
noError()
string subErrorName = "Function Name - "
string subError

// Fuction Code ===========================================================================
	found = findPlainText(thisText, this, off, len, false)
	if (found)
	{
		itemTemp = thisText[0:off-1]
		remTemp = thisText[off+1:]
		thisInd = index
		put (returnList, itemTemp, thisInd)
		index++
		getRid2(remTemp, returnList, index)
		
	}
	else
	{
		//index++
		thisInd = index

		put (returnList, thisText, thisInd )
	}



// ========================================================================================

//Error Control
	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
string defListBuild(string defList)
{
//Boolean
bool found = false

//Integers
int off = 0
int len = 0

//Strings
string thisList = ""

//Arrays

//Skip List

//Modules

//Objects

//Folder and Projects

//Items

//Attributes and Definitions

//Filters

//Other

//Error Control
noError()
string subErrorName = "Function Name - "
string subError

// Fuction Code ===========================================================================


	Regexp line = regexp ".*"
	while (!null defList && line defList) 
	{
		if (thisList == "")
		{
			thisList = defList[match 0]
		}
		else
		{
			thisList = thisList "," defList[match 0]
		}

		defList  = defList[end 0+2:]
	} 
	return thisList

// ========================================================================================

//Error Control
	subError = lastError
	if(!null subError)
	{
	 	ack subErrorName subError 
	}

}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
void createAObjAtt(Module mod, string anInf, string aT, string desc)
{
	if (!attrExists(mod , anInf  ))
	{
		AttrDef adRec
		adRec = create object type aT	description desc history false 	changeBars false date false inherit true attribute anInf
		//adRec = create object type aT history false 	changeBars false date false inherit true attribute anInf

	}
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

bool dumpParagraphs(string s, string flag)
{
RichTextParagraph rp
int thisVal

bool result = false

	for rp in s do 
	{

		if(flag == "I")
		{
			if(rp.indentLevel != 0)
			{
				result = true
			}
		}

		if(flag == "B")
		{
			if(rp.isBullet == true)
			{
				result = true
			}
		}

		//print "****New paragraph\n"
		//print "text:" rp.text ":\n "
		//print "indent:" rp.indentLevel ": "
		//print "bullet:" rp.isBullet ": "
		//print "bulletStyle:" rp.bulletStyle ":\n"
	}
	return result
}